/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Phase;
import org.zkoss.bind.impl.AnnotationUtil;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.BinderImpl;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.impl.SystemConverters;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.debugger.BindingAnnotationInfoChecker;
import org.zkoss.lang.Strings;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.zhtml.impl.AbstractTag;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;

public class AnnotateBinderHelper {
    private final Binder _binder;
    public static final String INIT_ANNO = "init";
    public static final String BIND_ANNO = "bind";
    public static final String LOAD_ANNO = "load";
    public static final String SAVE_ANNO = "save";
    public static final String REFERENCE_ANNO = "ref";
    public static final String ID_ANNO = "id";
    public static final String VALIDATOR_ANNO = "validator";
    public static final String CONVERTER_ANNO = "converter";
    public static final String TEMPLATE_ANNO = "template";
    public static final String COMMAND_ANNO = "command";
    public static final String GLOBAL_COMMAND_ANNO = "global-command";
    public static final String FORM_ATTR = "form";
    public static final String VIEW_MODEL_ATTR = "viewModel";
    public static final String BINDER_ATTR = "binder";
    public static final String VALIDATION_MESSAGES_ATTR = "validationMessages";
    public static final String CHILDREN_ATTR = "children";
    public static final String CHILDREN_KEY = "$CHILDREN$";

    public AnnotateBinderHelper(Binder binder) {
        this._binder = binder;
    }

    public void initComponentBindings(Component comp) {
        this.processAllComponentsBindings(comp);
    }

    private void processAllComponentsBindings(Component comp) {
        Binder selfBinder = BinderUtil.getBinder(comp);
        if (selfBinder != null) {
            return;
        }
        BindingAnnotationInfoChecker checker = ((BinderCtrl)((Object)this._binder)).getBindingAnnotationInfoChecker();
        if (checker != null) {
            checker.checkBinding(this._binder, comp);
        }
        this.processComponentBindings0(comp);
        for (Component kid : comp.getChildren()) {
            if (!kid.hasAttribute("$BINDER_ID$")) {
                this.processAllComponentsBindings(kid);
                continue;
            }
            if (!kid.hasAttribute("$REMOVE_BINDINGS$")) continue;
            kid.removeAttribute("$REMOVE_BINDINGS$");
            Binder nestedBinder = (Binder)kid.getAttribute((String)kid.getAttribute("$BINDER_ID$"));
            new AnnotateBinderHelper(nestedBinder).initComponentBindings(kid);
            BinderUtil.markHandling(kid, nestedBinder);
            ((BinderImpl)nestedBinder).initQueue();
            ((BinderImpl)nestedBinder).initActivator();
            nestedBinder.loadComponent(kid, true);
        }
        if (comp instanceof ComponentCtrl) {
            for (ShadowElement se : ((ComponentCtrl)comp).getShadowRoots()) {
                this.processAllComponentsBindings((Component)se);
            }
        }
    }

    private void processComponentBindings0(Component comp) {
        List<String> props = AnnotationUtil.getNonSystemProperties(comp);
        for (String propName : props) {
            if (this.isEventProperty(propName)) {
                this.processCommandBinding(comp, propName);
                this.processGlobalCommandBinding(comp, propName);
                continue;
            }
            if (FORM_ATTR.equals(propName)) {
                this.processFormBindings(comp);
                continue;
            }
            if (CHILDREN_ATTR.equals(propName)) {
                this.processChildrenBindings(comp);
                continue;
            }
            if (VIEW_MODEL_ATTR.equals(propName) || BINDER_ATTR.equals(propName) || VALIDATION_MESSAGES_ATTR.equals(propName)) continue;
            this.processPropertyBindings(comp, propName);
        }
    }

    private boolean isEventProperty(String propName) {
        return propName.startsWith("on") && propName.length() >= 3 && Character.isUpperCase(propName.charAt(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommandBinding(Component comp, String propName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Collection anncol = compCtrl.getAnnotations(propName, COMMAND_ANNO);
        if (anncol.size() == 0) {
            return;
        }
        if (anncol.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one command binding for event " + propName + " of " + String.valueOf(comp), comp));
        }
        Annotation ann = (Annotation)anncol.iterator().next();
        Map attrs = ann.getAttributes();
        LinkedHashMap<String, String[]> args = null;
        ArrayList<String> cmdExprs = new ArrayList<String>();
        Binder commandBinder = this._binder;
        for (Map.Entry entry : attrs.entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                cmdExprs.add(AnnotationUtil.testString(tagExpr, ann));
                continue;
            }
            if (args == null) {
                args = new LinkedHashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            for (String cmd : cmdExprs) {
                commandBinder.addCommandBinding(comp, propName, cmd, parsedArgs);
            }
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGlobalCommandBinding(Component comp, String propName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Collection anncol = compCtrl.getAnnotations(propName, GLOBAL_COMMAND_ANNO);
        if (anncol.size() == 0) {
            return;
        }
        if (anncol.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one global-command binding for event " + propName + " of " + String.valueOf(comp), comp));
        }
        Annotation ann = (Annotation)anncol.iterator().next();
        Map attrs = ann.getAttributes();
        LinkedHashMap<String, String[]> args = null;
        ArrayList<String> cmdExprs = new ArrayList<String>();
        for (Map.Entry entry : attrs.entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                cmdExprs.add(AnnotationUtil.testString(tagExpr, ann));
                continue;
            }
            if (args == null) {
                args = new LinkedHashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            for (String cmd : cmdExprs) {
                this._binder.addGlobalCommandBinding(comp, propName, cmd, parsedArgs);
            }
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private BindContext doPreInitPhase(Component comp, String propName) {
        if (this._binder instanceof BinderImpl) {
            BindContext ctx = BindContextUtil.newBindContext(this._binder, null, false, propName, comp, null);
            ((BinderImpl)this._binder).doPrePhase(Phase.INITIAL_BINDING, ctx);
            return ctx;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPropertyBindings(Component comp, String propName) {
        BindContext ctx;
        block14: {
            ComponentCtrl compCtrl = (ComponentCtrl)comp;
            ExpressionAnnoInfo validatorInfo = this.parseValidator(comp, propName);
            ExpressionAnnoInfo converterInfo = this.parseConverter(comp, propName);
            ctx = null;
            try {
                Collection initannos = compCtrl.getAnnotations(propName, INIT_ANNO);
                if (initannos.size() > 1) {
                    throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one @init for " + propName + " of " + String.valueOf(comp), (Annotation)initannos.iterator().next()));
                }
                if (initannos.size() == 1) {
                    this.processPropertyInit(comp, propName, (Annotation)initannos.iterator().next(), converterInfo);
                }
                Collection annos = compCtrl.getAnnotations(propName);
                for (Annotation anno : annos) {
                    if (anno.getName().equals(BIND_ANNO)) {
                        if (ctx == null) {
                            ctx = this.doPreInitPhase(comp, propName);
                        }
                        this.processPropertyPromptBindings(comp, propName, anno, converterInfo, validatorInfo);
                        continue;
                    }
                    if (anno.getName().equals(LOAD_ANNO)) {
                        if (ctx == null) {
                            ctx = this.doPreInitPhase(comp, propName);
                        }
                        this.processPropertyLoadBindings(comp, propName, anno, converterInfo);
                        continue;
                    }
                    if (anno.getName().equals(SAVE_ANNO)) {
                        if (ctx == null) {
                            ctx = this.doPreInitPhase(comp, propName);
                        }
                        this.processPropertySaveBindings(comp, propName, anno, converterInfo, validatorInfo);
                        continue;
                    }
                    if (!anno.getName().equals(REFERENCE_ANNO)) continue;
                    if (ctx == null) {
                        ctx = this.doPreInitPhase(comp, propName);
                    }
                    this.processReferenceBinding(comp, propName, anno);
                }
                ExpressionAnnoInfo templateInfo = this.parseTemplate(comp, propName);
                if (templateInfo == null) break block14;
                this._binder.setTemplate(comp, propName, templateInfo.expr, templateInfo.args);
            }
            catch (Throwable throwable) {
                if (this._binder instanceof BinderImpl && ctx != null) {
                    ((BinderImpl)this._binder).doPostPhase(Phase.INITIAL_BINDING, ctx);
                }
                throw throwable;
            }
        }
        if (this._binder instanceof BinderImpl && ctx != null) {
            ((BinderImpl)this._binder).doPostPhase(Phase.INITIAL_BINDING, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReferenceBinding(Component comp, String propName, Annotation ann) {
        String loadExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addReferenceBinding(comp, propName, loadExpr, parsedArgs);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPropertyInit(Component comp, String propName, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String initExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                initExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addPropertyInitBinding(comp, propName, initExpr, parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPropertyPromptBindings(Component comp, String propName, Annotation ann, ExpressionAnnoInfo converterInfo, ExpressionAnnoInfo validatorInfo) {
        String expr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                expr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("@bind is for prompt binding only, doesn't support before commands, check property " + propName + " of " + String.valueOf(comp), ann));
            }
            if ("after".equals(tag)) {
                throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("@bind is for prompt binding only, doesn't support after commands, check property " + propName + " of " + String.valueOf(comp), ann));
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.UtilContext ctx = BinderUtil.pushContext();
            ctx.setIgnoreAccessCreationWarn(true);
            ctx.setCurrentLocation(ann.getLocation());
            this._binder.addPropertyLoadBindings(comp, propName, expr, null, null, parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
            this._binder.addPropertySaveBindings(comp, propName, expr, null, null, parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args, validatorInfo == null ? null : validatorInfo.expr, validatorInfo == null ? null : validatorInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private void addCommand(Component comp, List<String> cmds, String[] cmdExprs) {
        for (String cmdExpr : cmdExprs) {
            this.addCommand(comp, cmds, cmdExpr);
        }
    }

    private void addCommand(Component comp, List<String> cmds, String cmdExpr) {
        String cmd = BindEvaluatorXUtil.eval(this._binder.getEvaluatorX(), comp, cmdExpr, String.class);
        if (Strings.isEmpty((String)cmd)) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("command of expression " + cmdExpr + " is empty", comp));
        }
        cmds.add(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPropertyLoadBindings(Component comp, String propName, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String loadExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addPropertyLoadBindings(comp, propName, loadExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPropertySaveBindings(Component comp, String propName, Annotation ann, ExpressionAnnoInfo converterInfo, ExpressionAnnoInfo validatorInfo) {
        String saveExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                saveExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addPropertySaveBindings(comp, propName, saveExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, converterInfo == null ? null : converterInfo.expr, converterInfo == null ? null : converterInfo.args, validatorInfo == null ? null : validatorInfo.expr, validatorInfo == null ? null : validatorInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private void processFormBindings(Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        BindEvaluatorX eval = this._binder.getEvaluatorX();
        ExpressionAnnoInfo validatorInfo = this.parseValidator(comp, FORM_ATTR);
        String formId = null;
        Collection idannos = compCtrl.getAnnotations(FORM_ATTR, ID_ANNO);
        if (idannos.size() == 0) {
            if (comp instanceof AbstractTag) {
                return;
            }
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("@id is not found for a form binding of " + String.valueOf(comp), comp));
        }
        if (idannos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one @id for a form binding of " + String.valueOf(comp), (Annotation)idannos.iterator().next()));
        }
        Annotation idanno = (Annotation)idannos.iterator().next();
        String idExpr = idanno.getAttribute("value");
        if (idExpr != null) {
            formId = BindEvaluatorXUtil.eval(eval, comp, idExpr, String.class);
        }
        if (formId == null) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("value of @id is not found for a form binding of " + String.valueOf(compCtrl) + ", exprssion is " + idExpr, idanno));
        }
        Collection initannos = compCtrl.getAnnotations(FORM_ATTR, INIT_ANNO);
        if (initannos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one @init for form of " + String.valueOf(comp), (Annotation)initannos.iterator().next()));
        }
        if (initannos.size() == 1) {
            this.processFormInit(comp, formId, (Annotation)initannos.iterator().next());
        }
        Collection annos = compCtrl.getAnnotations(FORM_ATTR);
        for (Annotation anno : annos) {
            if (anno.getName().equals(LOAD_ANNO)) {
                this.processFormLoadBindings(comp, formId, anno);
                continue;
            }
            if (!anno.getName().equals(SAVE_ANNO)) continue;
            this.processFormSaveBindings(comp, formId, anno, validatorInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFormInit(Component comp, String formId, Annotation ann) {
        String initExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                initExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addFormInitBinding(comp, formId, initExpr, parsedArgs);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFormLoadBindings(Component comp, String formId, Annotation ann) {
        String loadExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addFormLoadBindings(comp, formId, loadExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFormSaveBindings(Component comp, String formId, Annotation ann, ExpressionAnnoInfo validatorInfo) {
        String saveExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                saveExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addFormSaveBindings(comp, formId, saveExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, validatorInfo == null ? null : validatorInfo.expr, validatorInfo == null ? null : validatorInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private void processChildrenBindings(Component comp) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        ExpressionAnnoInfo converterInfo = this.parseConverter(comp, CHILDREN_ATTR);
        Collection initannos = compCtrl.getAnnotations(CHILDREN_ATTR, INIT_ANNO);
        if (initannos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one @init for children of " + String.valueOf(comp), (Annotation)initannos.iterator().next()));
        }
        if (initannos.size() == 1) {
            this.processChildrenInit(comp, (Annotation)initannos.iterator().next(), converterInfo);
        }
        Collection annos = compCtrl.getAnnotations(CHILDREN_ATTR);
        for (Annotation anno : annos) {
            if (anno.getName().equals(BIND_ANNO)) {
                this.processChildrenPromptBindings(comp, anno, converterInfo);
                continue;
            }
            if (!anno.getName().equals(LOAD_ANNO)) continue;
            this.processChildrenLoadBindings(comp, anno, converterInfo);
        }
        ExpressionAnnoInfo templateInfo = this.parseTemplate(comp, CHILDREN_ATTR);
        if (templateInfo != null) {
            this._binder.setTemplate(comp, CHILDREN_KEY, templateInfo.expr, templateInfo.args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChildrenInit(Component comp, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String initExpr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                initExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addChildrenInitBinding(comp, initExpr, parsedArgs, converterInfo == null ? this.getDefaultChildBindingConverter() : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private String getDefaultChildBindingConverter() {
        if (SystemConverters.get("childrenBinding") != null) {
            return "'childrenBinding'";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChildrenPromptBindings(Component comp, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String expr = null;
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                expr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("@bind is for prompt binding only, doesn't support before commands, check property children of " + String.valueOf(comp), comp));
            }
            if ("after".equals(tag)) {
                throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("@bind is for prompt binding only, doesn't support after commands, check property children of " + String.valueOf(comp), comp));
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addChildrenLoadBindings(comp, expr, null, null, parsedArgs, converterInfo == null ? this.getDefaultChildBindingConverter() : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChildrenLoadBindings(Component comp, Annotation ann, ExpressionAnnoInfo converterInfo) {
        String loadExpr = null;
        ArrayList<String> beforeCmds = new ArrayList<String>();
        ArrayList<String> afterCmds = new ArrayList<String>();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                loadExpr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if ("before".equals(tag)) {
                this.addCommand(comp, beforeCmds, tagExpr);
                continue;
            }
            if ("after".equals(tag)) {
                this.addCommand(comp, afterCmds, tagExpr);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        Map<String, Object> parsedArgs = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        try {
            BinderUtil.pushContext().setCurrentLocation(ann.getLocation());
            this._binder.addChildrenLoadBindings(comp, loadExpr, beforeCmds.size() == 0 ? null : beforeCmds.toArray(new String[beforeCmds.size()]), afterCmds.size() == 0 ? null : afterCmds.toArray(new String[afterCmds.size()]), parsedArgs, converterInfo == null ? this.getDefaultChildBindingConverter() : converterInfo.expr, converterInfo == null ? null : converterInfo.args);
        }
        finally {
            BinderUtil.popContext();
        }
    }

    private ExpressionAnnoInfo parseConverter(Component comp, String propName) {
        Collection annos = ((ComponentCtrl)comp).getAnnotations(propName, CONVERTER_ANNO);
        if (annos.size() == 0) {
            return null;
        }
        if (annos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one converter for " + propName + " of " + String.valueOf(comp), comp));
        }
        Annotation ann = (Annotation)annos.iterator().next();
        ExpressionAnnoInfo info = new ExpressionAnnoInfo();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                info.expr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        if (Strings.isBlank((String)info.expr)) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("value of converter is empty, check " + propName + " of " + String.valueOf(comp), comp));
        }
        info.args = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        return info;
    }

    private ExpressionAnnoInfo parseValidator(Component comp, String propName) {
        Collection annos = ((ComponentCtrl)comp).getAnnotations(propName, VALIDATOR_ANNO);
        if (annos.size() == 0) {
            return null;
        }
        if (annos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one validator for " + propName + " of " + String.valueOf(comp), comp));
        }
        Annotation ann = (Annotation)annos.iterator().next();
        ExpressionAnnoInfo info = new ExpressionAnnoInfo();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                info.expr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        if (Strings.isBlank((String)info.expr)) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("value of validator is empty, check " + propName + " of " + String.valueOf(comp), comp));
        }
        info.args = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        return info;
    }

    private ExpressionAnnoInfo parseTemplate(Component comp, String propName) {
        Collection annos = ((ComponentCtrl)comp).getAnnotations(propName, TEMPLATE_ANNO);
        if (annos.size() == 0) {
            return null;
        }
        if (annos.size() > 1) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Allow only one template for " + propName + " of " + String.valueOf(comp), comp));
        }
        Annotation ann = (Annotation)annos.iterator().next();
        ExpressionAnnoInfo info = new ExpressionAnnoInfo();
        HashMap<String, String[]> args = null;
        for (Map.Entry entry : ann.getAttributes().entrySet()) {
            String tag = (String)entry.getKey();
            String[] tagExpr = (String[])entry.getValue();
            if ("value".equals(tag)) {
                info.expr = AnnotationUtil.testString(tagExpr, ann);
                continue;
            }
            if (args == null) {
                args = new HashMap<String, String[]>();
            }
            args.put(tag, tagExpr);
        }
        if (Strings.isBlank((String)info.expr)) {
            throw new IllegalSyntaxException(MiscUtil.formatLocationMessage("Must specify a template for " + propName + " of " + String.valueOf(comp), comp));
        }
        info.args = args == null ? null : BindEvaluatorXUtil.parseArgs(this._binder.getEvaluatorX(), args);
        return info;
    }

    private static class ExpressionAnnoInfo {
        Map<String, Object> args;
        String expr;

        private ExpressionAnnoInfo() {
        }
    }
}

