/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.AbstractForEachStatus;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.impl.ReferenceBindingImpl;
import org.zkoss.bind.impl.TemplateRendererCtrl;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.TemplateResolver;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlShadowElement;
import org.zkoss.zk.ui.ShadowElement;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.Template;

public abstract class AbstractRenderer
implements TemplateRendererCtrl,
Serializable {
    private static final long serialVersionUID = 3738037033671761825L;
    protected static final String EACH_ATTR = "var";
    protected static final String EACH_VAR = "each";
    protected static final String STATUS_ATTR = "status";
    protected static final String STATUS_POST_VAR = "Status";
    protected static final String EACH_STATUS_VAR = "forEachStatus";
    protected static final String IS_TEMPLATE_MODEL_ENABLED_ATTR = "$isTemplateModelEnabled$";
    protected static final String CURRENT_INDEX_RESOLVER_ATTR = "$currentIndexResolver$";
    protected static final String RENDERED_COMPONENTS = "$RENDERED_COMPONENTS$";
    private String _attributeName;
    private boolean isFirstTime = false;

    @Override
    public void setAttributeName(String name) {
        this._attributeName = name;
    }

    private Template lookupTemplate(Component comp, String name) {
        if (comp == null) {
            return null;
        }
        Template template = comp.getTemplate(name);
        return template == null ? this.lookupTemplate(comp.getParent(), name) : template;
    }

    protected Template resolveTemplate(Component templateComp, Component comp, Object data, int index, int size, String defaultName) {
        return this.resolveTemplate(templateComp, comp, data, index, size, defaultName, null);
    }

    protected Template resolveTemplate(Component templateComp, Component comp, Object data, int index, int size, String defaultName, String subType) {
        if (comp.getPage() == null) {
            return null;
        }
        Binder binder = BinderUtil.getBinder(comp, true);
        TemplateResolver resolver = ((BinderCtrl)((Object)binder)).getTemplateResolver(templateComp, this._attributeName);
        Template template = null;
        if (resolver != null) {
            template = resolver.resolveTemplate(comp, data, index, size, subType);
            if (template == null) {
                throw new UiException("template not found for component " + String.valueOf(comp) + " by resolver " + String.valueOf(resolver));
            }
        } else {
            template = this.lookupTemplate(comp, (String)(subType == null ? defaultName : defaultName + ":" + subType));
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkShadowElementAndCreateSubChildren(Component parent) {
        boolean hasShadow = false;
        if (parent instanceof ComponentCtrl) {
            ComponentCtrl pCtrl = (ComponentCtrl)parent;
            for (ShadowElement se : pCtrl.getShadowRoots()) {
                HtmlShadowElement hse;
                if (se instanceof HtmlShadowElement && ((hse = (HtmlShadowElement)se).hasBindingAnnotation() || hse.hasSubBindingAnnotation())) {
                    hse.setAttribute("$BINDRENDERING$", (Object)true);
                    try {
                        Events.sendEvent((Event)new Event("onBindInit", (Component)hse));
                        Events.sendEvent((Event)new Event("onBindingReady", (Component)hse));
                    }
                    finally {
                        hse.removeAttribute("$BINDRENDERING$");
                    }
                }
                hasShadow = true;
            }
        }
        return hasShadow;
    }

    protected Component[] filterOutShadows(Component parent, Component[] items) {
        boolean hasShadow = this.checkShadowElementAndCreateSubChildren(parent);
        for (Component item : items) {
            this.checkShadowElementAndCreateSubChildren(item);
        }
        return hasShadow ? ShadowElementsCtrl.filterOutShadows((Component[])items) : items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTemplateTracking(Component templateComp, Component eachComp, final Object data, final int index, final int size) {
        Binder binder = BinderUtil.getBinder(eachComp, true);
        if (binder == null) {
            return;
        }
        TemplateResolver resolver = ((BinderCtrl)((Object)binder)).getTemplateResolver(templateComp, this._attributeName);
        if (resolver == null) {
            return;
        }
        Object old = null;
        Object oldStatus = null;
        try {
            old = eachComp.setAttribute(EACH_VAR, data);
            oldStatus = eachComp.setAttribute(EACH_STATUS_VAR, (Object)new AbstractForEachStatus(){
                private static final long serialVersionUID = 1L;

                public int getIndex() {
                    return index;
                }

                public Integer getEnd() {
                    if (size < 0) {
                        throw new UiException("end attribute is not supported");
                    }
                    return size;
                }

                public Object getCurrent() {
                    return data;
                }
            });
            resolver.addTemplateTracking(eachComp, data, index, size);
        }
        catch (Throwable throwable) {
            eachComp.setAttribute(EACH_STATUS_VAR, oldStatus);
            eachComp.setAttribute(EACH_VAR, old);
            throw throwable;
        }
        eachComp.setAttribute(EACH_STATUS_VAR, oldStatus);
        eachComp.setAttribute(EACH_VAR, old);
    }

    protected void addItemReference(Component modelOwner, Component comp, int index, String varnm) {
        if (comp.getDefinition().isNative()) {
            for (Component child : comp.getChildren()) {
                this.addItemReference(modelOwner, child, index, varnm);
            }
        } else {
            Binder binder = BinderUtil.getBinder(comp, true);
            if (binder == null) {
                return;
            }
            Object expression = comp.hasAttribute(IS_TEMPLATE_MODEL_ENABLED_ATTR) ? CURRENT_INDEX_RESOLVER_ATTR : BindELContext.getModelName(modelOwner) + "[" + index + "]";
            comp.setAttribute(varnm, (Object)new ReferenceBindingImpl(binder, comp, varnm, (String)expression));
        }
    }
}

