/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.zkoss.bind.Form;
import org.zkoss.bind.annotation.Immutable;
import org.zkoss.bind.annotation.ImmutableFields;
import org.zkoss.bind.proxy.BeanProxyHandler;
import org.zkoss.bind.proxy.FormFieldCleaner;
import org.zkoss.bind.proxy.FormProxyHandler;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ListModelArrayProxy;
import org.zkoss.bind.proxy.ListModelListProxy;
import org.zkoss.bind.proxy.ListModelMapProxy;
import org.zkoss.bind.proxy.ListModelSetProxy;
import org.zkoss.bind.proxy.ListProxy;
import org.zkoss.bind.proxy.MapProxy;
import org.zkoss.bind.proxy.ProxyNode;
import org.zkoss.bind.proxy.ProxyTargetHandler;
import org.zkoss.bind.proxy.SetProxy;
import org.zkoss.bind.proxy.ZKProxyTargetHandlers;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.SystemException;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.ListModelArray;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.ListModelMap;
import org.zkoss.zul.ListModelSet;

public class ProxyHelper {
    private static final Map<Class<?>, Boolean> _ignoredClasses;
    private static final Map<Class<?>, Boolean> _ignoredSuperClasses;
    private static final List<ProxyTargetHandler> _proxyTargetHandlers;
    private static ProxyDecorator _proxyDecorator;

    public static <T> T createProxyIfAny(T origin) {
        return ProxyHelper.createProxyIfAny(origin, null);
    }

    public static <T> T createProxyIfAny(T origin, Annotation[] annotations) {
        Object p1;
        if (origin == null) {
            return null;
        }
        if (origin instanceof FormProxyObject) {
            return origin;
        }
        origin = ProxyHelper.getOriginObject(origin);
        boolean hasImmutableFields = false;
        if (annotations != null) {
            for (Annotation annot : annotations) {
                if (annot.annotationType().isAssignableFrom(Immutable.class)) {
                    return origin;
                }
                if (!annot.annotationType().isAssignableFrom(ImmutableFields.class)) continue;
                hasImmutableFields = true;
            }
        }
        if (ProxyHelper.isImmutable(origin)) {
            return origin;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setUseWriteReplace(false);
        if (origin instanceof ListModelList) {
            return (T)new ListModelListProxy((ListModelList)origin, annotations);
        }
        if (origin instanceof ListModelSet) {
            return (T)new ListModelSetProxy((ListModelSet)origin, annotations);
        }
        if (origin instanceof ListModelMap) {
            return (T)new ListModelMapProxy((ListModelMap)origin, annotations);
        }
        if (origin instanceof ListModelArray) {
            return (T)new ListModelArrayProxy((ListModelArray)origin, annotations);
        }
        if (origin instanceof List) {
            return (T)new ListProxy((List)origin, annotations);
        }
        if (origin instanceof Set) {
            return (T)new SetProxy((Set)origin, annotations);
        }
        if (origin instanceof Map) {
            return (T)new MapProxy((Map)origin, annotations);
        }
        if (origin instanceof Collection) {
            return (T)new ListProxy((Collection)origin, annotations);
        }
        if (origin.getClass().isArray()) {
            throw new UnsupportedOperationException("Array cannot be a proxy object!");
        }
        factory.setFilter(BeanProxyHandler.BEAN_METHOD_FILTER);
        factory.setSuperclass(ProxyHelper.getTargetClassIfProxied(origin.getClass()));
        if (hasImmutableFields) {
            factory.setInterfaces(new Class[]{FormProxyObject.class, ImmutableFields.class});
        } else {
            factory.setInterfaces(new Class[]{FormProxyObject.class});
        }
        Class proxyClass = factory.createClass();
        try {
            p1 = proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e, (String)("Cannot create a proxy object:[" + String.valueOf(origin.getClass()) + "], an empty constructor is needed."));
        }
        ((Proxy)p1).setHandler(new BeanProxyHandler<T>(origin));
        return (T)(_proxyDecorator != null ? _proxyDecorator.decorate((ProxyObject)p1) : p1);
    }

    public static void addIgnoredProxyClass(Class<?> type) {
        _ignoredClasses.put(type, Boolean.TRUE);
    }

    public static void addIgnoredSuperProxyClass(Class<?> type) {
        _ignoredSuperClasses.put(type, Boolean.TRUE);
    }

    public static boolean isImmutable(Object origin) {
        if (BindELContext.isImmutable(origin)) {
            return true;
        }
        return ProxyHelper.checkImmutable(origin.getClass());
    }

    private static <T> Class<?> getTargetClassIfProxied(Class<T> clazz) {
        if (ProxyFactory.isProxyClass(clazz)) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static <T> T getOriginObject(T origin) {
        for (ProxyTargetHandler handlers : _proxyTargetHandlers) {
            if (handlers == null) continue;
            origin = handlers.getOriginObject(origin);
        }
        return origin;
    }

    private static boolean checkImmutable(Class<?> type) {
        if (_ignoredClasses.containsKey(type)) {
            return true;
        }
        if (Modifier.isFinal(type.getModifiers())) {
            _ignoredClasses.put(type, Boolean.TRUE);
            return true;
        }
        for (Map.Entry<Class<?>, Boolean> clzInfo : _ignoredSuperClasses.entrySet()) {
            if (!clzInfo.getKey().isAssignableFrom(type)) continue;
            _ignoredClasses.put(type, Boolean.TRUE);
            return true;
        }
        return false;
    }

    public static <T> T createFormProxy(T origin, Class<?> type) {
        return ProxyHelper.createFormProxy(origin, type, null);
    }

    public static <T> T createFormProxy(T origin, Class<?> type, Class[] interfaces) {
        Object p1;
        if (origin instanceof Form) {
            return origin;
        }
        origin = ProxyHelper.getOriginObject(origin);
        ProxyFactory factory = new ProxyFactory();
        factory.setUseWriteReplace(false);
        factory.setFilter(FormProxyHandler.FORM_METHOD_FILTER);
        if (origin instanceof FormProxyObject) {
            type = ((FormProxyObject)origin).getOriginObject().getClass();
        } else if (origin != null) {
            type = ProxyHelper.getTargetClassIfProxied(origin.getClass());
        }
        boolean isTypeInterface = type.isInterface();
        if (!isTypeInterface) {
            factory.setSuperclass(type);
        }
        int i = 0;
        int len0 = interfaces != null ? interfaces.length : 0;
        Class[] newArray = new Class[len0 + 3 + (isTypeInterface ? 1 : 0)];
        if (interfaces != null) {
            i += len0;
            System.arraycopy(interfaces, 0, newArray, 0, len0);
        }
        newArray[i++] = FormProxyObject.class;
        newArray[i++] = Form.class;
        newArray[i++] = FormFieldCleaner.class;
        if (isTypeInterface) {
            newArray[i] = type;
        }
        factory.setInterfaces(newArray);
        Class proxyClass = factory.createClass();
        try {
            p1 = proxyClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e, (String)("Cannot create a proxy object:[" + String.valueOf(origin != null ? origin.getClass() : null) + "], an empty constructor is needed."));
        }
        ((Proxy)p1).setHandler(new FormProxyHandler<T>(origin));
        return (T)(_proxyDecorator != null ? _proxyDecorator.decorate((ProxyObject)p1) : p1);
    }

    static void cacheSavePropertyBinding(ProxyNode node, String property, SavePropertyBinding savePropertyBinding) {
        while (node != null) {
            ProxyNode parent = node.getParent();
            if (parent == null) {
                node.getCachedSavePropertyBinding().add((Pair<String, SavePropertyBinding>)new Pair(property, (Object)savePropertyBinding));
                break;
            }
            Object parentProperty = parent.getProperty();
            if (!((String)property).startsWith("[") && parentProperty != null && !((String)parentProperty).isEmpty()) {
                parentProperty = (String)parentProperty + ".";
            }
            property = (String)parentProperty + (String)property;
            node = parent;
        }
    }

    static void callOnDataChange(ProxyNode node, Object value) {
        while (node != null) {
            ProxyNode parent = node.getParent();
            if (parent == null && node.getOnDataChangeCallback() != null) {
                node.getOnDataChangeCallback().call(value);
                break;
            }
            node = parent;
        }
    }

    static void callOnDirtyChange(ProxyNode node) {
        while (node != null) {
            ProxyNode parent = node.getParent();
            if (parent == null && node.getOnDirtyChangeCallback() != null) {
                node.getOnDirtyChangeCallback().call((Object)true);
                break;
            }
            node = parent;
        }
    }

    public static String toSetter(String attr) {
        return ProxyHelper.capitalize("set", attr);
    }

    public static String toGetter(String attr) {
        return ProxyHelper.capitalize("get", attr);
    }

    public static String capitalize(String prefix, String attr) {
        return prefix + Character.toUpperCase(attr.charAt(0)) + attr.substring(1);
    }

    public static boolean isAttribute(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        String nm = method.getName();
        int len = nm.length();
        switch (method.getParameterTypes().length) {
            case 0: {
                if (len >= 3 && nm.startsWith("is")) {
                    return true;
                }
                return len >= 4 && nm.startsWith("get");
            }
            case 1: {
                return len >= 4 && nm.startsWith("set");
            }
        }
        return false;
    }

    public static String toAttrName(Method method, int prefix) {
        String name = method.getName();
        String attrName = name.substring(prefix);
        return Character.toLowerCase(attrName.charAt(0)) + attrName.substring(1);
    }

    public static String toAttrName(Method method) {
        return ProxyHelper.toAttrName(method, 3);
    }

    static {
        List superClasses;
        _ignoredClasses = new ConcurrentHashMap();
        _ignoredSuperClasses = new ConcurrentHashMap();
        List classes = Library.getProperties((String)"org.zkoss.bind.proxy.IgnoredProxyClasses");
        if (classes != null && !classes.isEmpty()) {
            for (Object className : classes) {
                try {
                    ProxyHelper.addIgnoredProxyClass(Classes.forNameByThread((String)((String)className).trim()));
                }
                catch (ClassNotFoundException ex) {
                    throw new SystemException("Failed to load class " + (String)className);
                }
            }
        }
        if ((superClasses = Library.getProperties((String)"org.zkoss.bind.proxy.IgnoredSuperProxyClasses")) != null && !superClasses.isEmpty()) {
            for (String className : superClasses) {
                try {
                    ProxyHelper.addIgnoredSuperProxyClass(Classes.forNameByThread((String)className.trim()));
                }
                catch (ClassNotFoundException ex) {
                    throw new SystemException("Failed to load class " + className);
                }
            }
        }
        _proxyTargetHandlers = new LinkedList<ProxyTargetHandler>(ZKProxyTargetHandlers.getSystemProxyTargetHandlers());
        String cls = Library.getProperty((String)"org.zkoss.bind.proxy.ProxyDecoratorClass");
        if (cls != null) {
            try {
                _proxyDecorator = (ProxyDecorator)Classes.newInstanceByThread((String)cls.trim());
            }
            catch (Exception e) {
                throw new SystemException("Failed to load class " + cls);
            }
        }
    }

    public static interface ProxyDecorator {
        public ProxyObject decorate(ProxyObject var1);
    }
}

