/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.xel.zel;

import java.beans.FeatureDescriptor;
import java.io.Serializable;
import java.util.Iterator;
import org.zkoss.bind.sys.ValidationMessages;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELException;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zel.PropertyNotWritableException;
import org.zkoss.zk.ui.Component;

public class ValidationMessagesELResolver
extends ELResolver {
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            return null;
        }
        if (base instanceof ValidationMessages) {
            int numOfKids = (Integer)context.getContext(Integer.class);
            ValidationMessages vms = (ValidationMessages)base;
            String[] msgs = null;
            if (property instanceof Component) {
                context.setPropertyResolved(true);
                if (numOfKids == 0) {
                    msgs = vms.getMessages((Component)property);
                    if (msgs == null || msgs.length == 0) {
                        return null;
                    }
                    return msgs[0];
                }
                return new ComponentResolver((ValidationMessages)base, (Component)property);
            }
            if (property instanceof String) {
                context.setPropertyResolved(true);
                if ("texts".equals(property)) {
                    return this.handleTexts((ValidationMessages)base, numOfKids);
                }
                msgs = vms.getKeyMessages((String)property);
                if (msgs == null || msgs.length == 0) {
                    return null;
                }
                return msgs[0];
            }
        } else if (base instanceof ValueResolver) {
            int numOfKids = (Integer)context.getContext(Integer.class);
            return ((ValueResolver)base).getValue(context, property, numOfKids);
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        return true;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }

    protected Object handleTexts(ValidationMessages base, int numOfKids) {
        if (numOfKids == 0) {
            return base.getMessages();
        }
        return new TextsResolver(base);
    }

    private static class TextsComponentResolver
    extends AbstractValueResolver {
        private static final long serialVersionUID = 1L;
        protected final Component _comp;

        TextsComponentResolver(ValidationMessages vms, Component comp) {
            super(vms);
            this._comp = comp;
        }

        @Override
        public Object getValue(ELContext context, Object property, int numOfKids) {
            String[] msgs = null;
            if (property instanceof String) {
                context.setPropertyResolved(true);
                return this._vms.getMessages(this._comp, (String)property);
            }
            if (property instanceof Number) {
                context.setPropertyResolved(true);
                msgs = this._vms.getMessages(this._comp);
                return msgs.length == 0 ? null : msgs[((Number)property).intValue()];
            }
            return null;
        }
    }

    private static class TextsResolver
    extends AbstractValueResolver {
        private static final long serialVersionUID = 1L;

        TextsResolver(ValidationMessages vms) {
            super(vms);
        }

        @Override
        public Object getValue(ELContext context, Object property, int numOfKids) {
            String[] msgs = null;
            if (property instanceof Component) {
                context.setPropertyResolved(true);
                if (numOfKids == 0) {
                    return this._vms.getMessages((Component)property);
                }
                return new TextsComponentResolver(this._vms, (Component)property);
            }
            if (property instanceof String) {
                context.setPropertyResolved(true);
                return this._vms.getKeyMessages((String)property);
            }
            if (property instanceof Number) {
                context.setPropertyResolved(true);
                msgs = this._vms.getMessages();
                return msgs.length == 0 ? null : msgs[((Number)property).intValue()];
            }
            return null;
        }
    }

    private static class ComponentResolver
    extends AbstractValueResolver {
        private static final long serialVersionUID = 1L;
        protected final Component _comp;

        ComponentResolver(ValidationMessages vms, Component comp) {
            super(vms);
            this._comp = comp;
        }

        @Override
        public Object getValue(ELContext context, Object property, int numOfKids) {
            String[] msgs = null;
            if (property instanceof String) {
                context.setPropertyResolved(true);
                msgs = this._vms.getMessages(this._comp, (String)property);
                if (msgs != null && msgs.length > 0) {
                    return msgs[0];
                }
                return null;
            }
            throw new PropertyNotFoundException("uknow property " + String.valueOf(property) + " for validation-messages[comp][*]");
        }
    }

    protected static abstract class AbstractValueResolver
    implements Serializable,
    ValueResolver {
        private static final long serialVersionUID = 1L;
        protected final ValidationMessages _vms;

        protected AbstractValueResolver(ValidationMessages vms) {
            this._vms = vms;
        }
    }

    protected static interface ValueResolver {
        public Object getValue(ELContext var1, Object var2, int var3);
    }
}

