/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.validator;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.Validator;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.PropertyBinding;
import org.zkoss.bind.sys.ValidationMessages;

public abstract class AbstractValidator
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(AbstractValidator.class);

    protected void addInvalidMessage(ValidationContext ctx, String message) {
        this.addInvalidMessages(ctx, null, new String[]{message});
    }

    protected void addInvalidMessage(ValidationContext ctx, String key, String message) {
        this.addInvalidMessages(ctx, key, new String[]{message});
    }

    protected void addInvalidMessage(ValidationContext ctx, String key, String message, Object value) {
        this.addInvalidMessages(ctx, key, new String[]{message}, value);
    }

    protected void addInvalidMessages(ValidationContext ctx, String[] messages) {
        this.addInvalidMessages(ctx, null, messages);
    }

    protected void addInvalidMessages(ValidationContext ctx, String key, String[] messages) {
        this.addInvalidMessages(ctx, key, messages, null);
    }

    protected void addInvalidMessages(ValidationContext ctx, String key, String[] messages, Object value) {
        ctx.setInvalid();
        ValidationMessages vmsgs = ((BinderCtrl)ctx.getBindContext().getBinder()).getValidationMessages();
        if (vmsgs != null) {
            Binding binding = ctx.getBindContext().getBinding();
            String attr = null;
            if (binding instanceof PropertyBinding) {
                attr = ((PropertyBinding)binding).getFieldName();
            } else if (binding instanceof FormBinding) {
                attr = ((FormBinding)binding).getFormId();
            }
            if (attr != null) {
                vmsgs.addMessages(ctx.getBindContext().getComponent(), attr, key, messages, value);
            }
        } else {
            log.warn("ValidationMessages not found on binder " + String.valueOf(ctx.getBindContext().getBinder()) + ", please init it");
        }
    }
}

