/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.init;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.ViewModelAnnotationResolver;
import org.zkoss.zk.ui.util.AggregationListener;

public class ViewModelAnnotationResolvers
implements AggregationListener {
    private static final Logger log = LoggerFactory.getLogger(ViewModelAnnotationResolvers.class);
    private static Map<String, ViewModelAnnotationResolver> _resolvers = new LinkedHashMap<String, ViewModelAnnotationResolver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHandled(Class<?> klass) {
        if (ViewModelAnnotationResolver.class.isAssignableFrom(klass)) {
            try {
                Map<String, ViewModelAnnotationResolver> map = _resolvers;
                synchronized (map) {
                    if (!_resolvers.containsKey(klass.getName())) {
                        _resolvers.put(klass.getName(), (ViewModelAnnotationResolver)klass.newInstance());
                    }
                }
            }
            catch (Exception e) {
                log.error("Error when initial view model annotation resolver:" + String.valueOf(klass), (Throwable)e);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ViewModelAnnotationResolver> getResolvers() {
        Collection<ViewModelAnnotationResolver> values;
        Map<String, ViewModelAnnotationResolver> map = _resolvers;
        synchronized (map) {
            values = _resolvers.values();
        }
        return new LinkedList<ViewModelAnnotationResolver>(values);
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        ViewModelAnnotationResolver resolver;
        T anno = null;
        List<ViewModelAnnotationResolver> resolvers = ViewModelAnnotationResolvers.getResolvers();
        Iterator<ViewModelAnnotationResolver> iterator = resolvers.iterator();
        while (iterator.hasNext() && (anno = (T)(resolver = iterator.next()).getAnnotation(method, annotationClass)) == null) {
        }
        return anno;
    }

    public static <T extends Annotation> T getAnnotation(Class clazz, Class<T> annotationClass) {
        ViewModelAnnotationResolver resolver;
        T anno = null;
        List<ViewModelAnnotationResolver> resolvers = ViewModelAnnotationResolvers.getResolvers();
        Iterator<ViewModelAnnotationResolver> iterator = resolvers.iterator();
        while (iterator.hasNext() && (anno = (T)(resolver = iterator.next()).getAnnotation(clazz, annotationClass)) == null) {
        }
        return anno;
    }

    public static Method getOriginalMethod(Object base, Method method) {
        ViewModelAnnotationResolver resolver;
        Method m = null;
        List<ViewModelAnnotationResolver> resolvers = ViewModelAnnotationResolvers.getResolvers();
        Iterator<ViewModelAnnotationResolver> iterator = resolvers.iterator();
        while (iterator.hasNext() && ((m = (resolver = iterator.next()).getOriginalMethod(base, method)) == null || method.equals(m))) {
        }
        return m;
    }
}

