/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.impl.AllocUtil;
import org.zkoss.bind.impl.BindChildRenderer;
import org.zkoss.bind.impl.ChildrenBindingImpl;
import org.zkoss.bind.impl.ChildrenBindingListDataListener;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.LoadChildrenBinding;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.impl.info.LoadInfo;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataListener;

public class LoadChildrenBindingImpl
extends ChildrenBindingImpl
implements LoadChildrenBinding {
    private static final long serialVersionUID = 1463169907348730644L;
    private Set<String> _doneDependsOn;

    public LoadChildrenBindingImpl(Binder binder, Component comp, String loadExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        super(binder, comp, loadExpr, conditionType, command, bindingArgs, converterExpr, converterArgs);
    }

    @Override
    public void load(BindContext ctx) {
        Component comp = this.getComponent();
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        BindingExecutionInfoCollector collector = ((BinderCtrl)this.getBinder()).getBindingExecutionInfoCollector();
        Object value = eval.getValue(ctx, comp, this._accessInfo.getProperty());
        boolean activating = ((BinderCtrl)this.getBinder()).isActivating();
        Converter conv = this.getConverter();
        Object old = value;
        if (conv != null) {
            if (activating) {
                return;
            }
            if ((value = conv.coerceToUi(value, comp, ctx)) == Converter.IGNORED_VALUE) {
                if (collector != null) {
                    collector.addInfo(new LoadInfo("children-load", comp, this.getConditionString(ctx), this.getPropertyString(), null, old, this.getArgs(), "*Converter.IGNORED_VALUE"));
                }
                return;
            }
        }
        if (activating) {
            return;
        }
        List cbrCompsList = (List)comp.getAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$");
        if (cbrCompsList != null) {
            cbrCompsList.clear();
        }
        for (Component cmp : new ArrayList(comp.getChildren())) {
            cmp.detach();
            Events.sendEvent((Event)new Event("onBindClean", comp));
        }
        BindELContext.removeModel(comp);
        if (value != null) {
            List data = null;
            if (!(value instanceof List)) {
                throw new UiException(String.valueOf(value) + " is not a List, is " + String.valueOf(value.getClass()));
            }
            data = (List)value;
            BindChildRenderer renderer = new BindChildRenderer();
            BindELContext.addModel(comp, data);
            boolean isUsingListModel = old instanceof ListModel;
            if (isUsingListModel) {
                Object model = comp.getAttribute("$CHILDREN_BINDING_MODEL$");
                if (model != null && !old.equals(model)) {
                    comp.removeAttribute("$CHILDREN_BINDING_RENDERED_COMPONENTS$");
                }
                ChildrenBindingListDataListener dataListener = new ChildrenBindingListDataListener(comp, ctx, conv);
                ((ListModel)old).addListDataListener((ListDataListener)dataListener);
                comp.setAttribute("$CHILDREN_BINDING_MODEL$", old);
                Object attribute = comp.setAttribute("$CHILDREN_BINDING_MODEL_LISTENER$", (Object)dataListener);
                if (attribute instanceof ListDataListener) {
                    ((ListModel)old).removeListDataListener((ListDataListener)attribute);
                }
            }
            int size = data.size();
            int i = 0;
            for (Object obj : data) {
                renderer.render(comp, obj, i++, size, isUsingListModel);
            }
        }
        if (collector != null) {
            collector.addInfo(new LoadInfo("children-load", comp, this.getConditionString(ctx), this.getPropertyString(), "", value, this.getArgs(), null));
        }
    }

    private String getConditionString(BindContext ctx) {
        StringBuilder condition = new StringBuilder();
        if (this.getConditionType() == ConditionType.BEFORE_COMMAND) {
            condition.append("before = '").append(this.getCommandName()).append("'");
        } else if (this.getConditionType() == ConditionType.AFTER_COMMAND) {
            condition.append("after = '").append(this.getCommandName()).append("'");
        } else {
            condition.append((String)(ctx.getTriggerEvent() == null ? "" : "event = " + ctx.getTriggerEvent().getName()));
        }
        return condition.length() == 0 ? null : condition.toString();
    }

    private Method getConverterMethod(Class<? extends Converter> cls) {
        try {
            return cls.getMethod("coerceToUi", Object.class, Component.class, BindContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public void addDependsOnTrackings(List<String> srcpath, String basepath, String[] props) {
        if (srcpath != null) {
            String src = BindELContext.pathToString(srcpath);
            if (this._doneDependsOn != null && this._doneDependsOn.contains(src)) {
                return;
            }
            this._doneDependsOn = AllocUtil.inst.addSet(this._doneDependsOn, src);
        }
        for (String prop : props) {
            BindELContext.addDependsOnTracking(this, srcpath, basepath, prop);
        }
    }
}

