/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.annotation.BindingParam;
import org.zkoss.bind.annotation.BindingParams;
import org.zkoss.bind.annotation.ContextParam;
import org.zkoss.bind.annotation.ContextType;
import org.zkoss.bind.annotation.CookieParam;
import org.zkoss.bind.annotation.Default;
import org.zkoss.bind.annotation.ExecutionArgParam;
import org.zkoss.bind.annotation.ExecutionParam;
import org.zkoss.bind.annotation.HeaderParam;
import org.zkoss.bind.annotation.QueryParam;
import org.zkoss.bind.annotation.Scope;
import org.zkoss.bind.annotation.ScopeParam;
import org.zkoss.bind.annotation.SelectorParam;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.init.ViewModelAnnotationResolvers;
import org.zkoss.bind.paranamer.AdaptiveParanamer;
import org.zkoss.bind.paranamer.CachingParanamer;
import org.zkoss.bind.paranamer.Paranamer;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.json.JSONAware;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.OperationException;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.select.Selectors;

public class ParamCall {
    private static final Logger _log = LoggerFactory.getLogger(ParamCall.class);
    private static final Paranamer _PARANAMER = new CachingParanamer(new AdaptiveParanamer());
    protected Map<Class<? extends Annotation>, ParamResolver<Annotation>> _paramResolvers = new HashMap<Class<? extends Annotation>, ParamResolver<Annotation>>();
    private List<Type> _types;
    private boolean _mappingType;
    private ContextObjects _contextObjects = new ContextObjects();
    private static final String COOKIE_CACHE = "$PARAM_COOKIES$";
    public static final String BINDING_PARAM_CALL_TYPE = "org.zkoss.bind.BindingParamCall.type";
    private Component _root = null;
    private Component _component = null;
    private Execution _execution = null;
    private Binder _binder = null;
    private BindContext _bindContext = null;
    protected Map<String, Object> _bindingArgs;

    public ParamCall() {
        this(true);
    }

    public ParamCall(boolean mappingType) {
        this._types = new ArrayList<Type>();
        this._mappingType = mappingType;
        this._paramResolvers.put(ContextParam.class, new ParamResolver<Annotation>(){

            @Override
            public Object resolveParameter(Annotation anno, Class<?> returnType, Supplier<String> parameterName) {
                Object val = ParamCall.this._contextObjects.get(((ContextParam)anno).value());
                return val == null ? null : Classes.coerce(returnType, (Object)val);
            }
        });
    }

    public void setBindContext(BindContext ctx) {
        this._bindContext = ctx;
        this._types.add(new Type(ctx.getClass(), this._bindContext));
    }

    public BindContext getBindContext() {
        return this._bindContext;
    }

    public void setBinder(Binder binder) {
        this._binder = binder;
        this._types.add(new Type(binder.getClass(), this._binder));
        this._root = binder.getView();
    }

    public Binder getBinder() {
        return this._binder;
    }

    public void setBindingArgs(final Map<String, Object> bindingArgs) {
        this._bindingArgs = bindingArgs;
        this._paramResolvers.put(BindingParam.class, new ParamResolver<Annotation>(){

            @Override
            public Object resolveParameter(Annotation anno, Class<?> returnType, Supplier<String> parameterName) {
                Object val = bindingArgs.get(ParamCall.this.getAnnotatedParameterName(BindingParam.class, ((BindingParam)anno).value(), parameterName));
                return ParamCall.this.resolveParameter0(val, returnType);
            }
        });
        this._paramResolvers.put(BindingParams.class, new ParamResolver<Annotation>(){

            @Override
            public Object resolveParameter(Annotation anno, Class<?> returnType, Supplier<String> parameterName) {
                try {
                    Object bean = Classes.newInstance(returnType, null);
                    BeanInfo beanInfo = Introspector.getBeanInfo(returnType);
                    for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                        String propertyName = pd.getName();
                        Object propertyValue = bindingArgs.get(propertyName);
                        if (propertyValue == null && !bindingArgs.containsKey(propertyName)) continue;
                        pd.getWriteMethod().invoke(bean, Classes.coerce(pd.getPropertyType(), propertyValue));
                    }
                    return bean;
                }
                catch (Exception e) {
                    _log.error("", (Throwable)e);
                    throw UiException.Aide.wrap((Throwable)e);
                }
            }
        });
    }

    protected String getAnnotatedParameterName(Class<? extends Annotation> annoClass, String annoValue, Supplier<String> parameterName) {
        if (!Strings.isEmpty((String)annoValue)) {
            return annoValue;
        }
        String value = parameterName.get();
        if (!Strings.isEmpty((String)value)) {
            return value;
        }
        throw new UiException("The parameter name can't be inferred. Please specify @" + annoClass.getSimpleName() + "(value) instead.");
    }

    public void call(Object base, Method method) {
        Method originalMethod = ViewModelAnnotationResolvers.getOriginalMethod(base, method);
        Class<?>[] paramTypes = originalMethod.getParameterTypes();
        Annotation[][] parmAnnos = originalMethod.getParameterAnnotations();
        Object[] params = new Object[paramTypes.length];
        try {
            for (int i = 0; i < paramTypes.length; ++i) {
                params[i] = this.resolveParameter(parmAnnos[i], paramTypes[i], originalMethod, i);
            }
            method.setAccessible(true);
            method.invoke(base, params);
        }
        catch (InvocationTargetException invokEx) {
            Throwable c = invokEx.getCause();
            if (c == null) {
                c = invokEx;
            }
            if (c instanceof OperationException) {
                if (_log.isDebugEnabled()) {
                    _log.debug("", c);
                }
            } else {
                _log.error("", c);
            }
            throw UiException.Aide.wrap((Throwable)c);
        }
        catch (Exception e) {
            _log.error("", (Throwable)e);
            throw UiException.Aide.wrap((Throwable)e);
        }
    }

    protected Object resolveParameter(Annotation[] parmAnnos, Class<?> paramType, Method method, int index) {
        Object positionalVal;
        Object val = null;
        boolean hitResolver = false;
        Default defAnno = null;
        for (Annotation anno : parmAnnos) {
            Class<? extends Annotation> annotype = anno.annotationType();
            if (defAnno == null && annotype.equals(Default.class)) {
                defAnno = (Default)anno;
                continue;
            }
            ParamResolver<Annotation> resolver = this._paramResolvers.get(annotype);
            if (resolver == null) continue;
            hitResolver = true;
            val = resolver.resolveParameter(anno, paramType, () -> {
                String[] parameterNames = _PARANAMER.lookupParameterNames(method, false);
                return index < parameterNames.length ? parameterNames[index] : "";
            });
            if (val != null) break;
        }
        boolean isDefaultVal = false;
        if (val == null && defAnno != null) {
            isDefaultVal = true;
            val = Classes.coerce(paramType, (Object)defAnno.value());
        }
        if (this._mappingType && val == null && !hitResolver && this._types != null) {
            for (Type type : this._types) {
                if (type == null || !paramType.isAssignableFrom(type.clz)) continue;
                val = type.value;
                isDefaultVal = false;
                break;
            }
        }
        if (val == null) {
            val = this.resolvePositionalOrNoAnnoParameter(paramType, method, index);
        } else if (isDefaultVal && (positionalVal = this.resolvePositionalOrNoAnnoParameter(paramType, method, index)) != null) {
            val = positionalVal;
        }
        return val;
    }

    private Object resolvePositionalOrNoAnnoParameter(Class<?> returnType, Method method, int index) {
        Object val = null;
        if (this._bindingArgs != null) {
            String[] parameterNames;
            int argIndex = 0;
            for (Map.Entry<String, Object> entry : this._bindingArgs.entrySet()) {
                if (argIndex == index) {
                    if (!entry.getKey().startsWith("zk_Param_")) break;
                    val = entry.getValue();
                    break;
                }
                ++argIndex;
            }
            if (val == null && index < (parameterNames = _PARANAMER.lookupParameterNames(method, false)).length) {
                val = this._bindingArgs.get(parameterNames[index]);
            }
            return this.resolveParameter0(val, returnType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object resolveParameter0(Object val, Class<?> returnType) {
        if (val != null && returnType.isAssignableFrom(val.getClass())) {
            return val;
        }
        if (Component.class.isAssignableFrom(returnType) && val instanceof String) {
            return this._root.getDesktop().getComponentByUuidIfAny((String)val);
        }
        if (val instanceof JSONAware) {
            BindContext bindContext = this.getBindContext();
            Binder binder = this.getBinder();
            Converter converter = binder.getConverter("jsonBindingParam");
            if (converter != null) {
                try {
                    Object result;
                    bindContext.setAttribute((Object)BINDING_PARAM_CALL_TYPE, returnType);
                    Object object = result = converter.coerceToBean(val, binder.getView(), bindContext);
                    return object;
                }
                catch (Exception ex) {
                    Object object = Classes.coerce(returnType, (Object)val);
                    return object;
                }
                finally {
                    bindContext.setAttribute((Object)BINDING_PARAM_CALL_TYPE, null);
                }
            }
            return Classes.coerce(returnType, (Object)val);
        }
        return val == null ? null : Classes.coerce(returnType, (Object)val);
    }

    public void setComponent(Component comp) {
        this._component = comp;
        this._paramResolvers.put(ScopeParam.class, new ParamResolver<Annotation>(){

            @Override
            public Object resolveParameter(Annotation anno, Class<?> returnType, Supplier<String> parameterName) {
                String name = ParamCall.this.getAnnotatedParameterName(ScopeParam.class, ((ScopeParam)anno).value(), parameterName);
                Scope[] ss = ((ScopeParam)anno).scopes();
                Object val = null;
                block3: for (Scope s : ss) {
                    switch (s) {
                        case AUTO: {
                            if (ss.length == 1) {
                                if (ParamCall.this._execution != null) {
                                    val = ParamCall.this._execution.getAttribute(name);
                                }
                                if (val != null) continue block3;
                                val = ParamCall.this._component.getAttribute(name, true);
                                continue block3;
                            }
                            throw new UiException("don't use " + String.valueOf((Object)s) + " with other scopes " + Arrays.toString((Object[])ss));
                        }
                    }
                }
                if (val == null) {
                    for (Scope scope : ss) {
                        String scopeName = scope.getName();
                        Object scopeObj = Components.getImplicit((Component)ParamCall.this._component, (String)scopeName);
                        if (scopeObj instanceof Map) {
                            val = ((Map)scopeObj).get(name);
                            if (val == null) continue;
                            break;
                        }
                        if (scopeObj == null) continue;
                        _log.error("the scope of " + scopeName + " is not a Map, is " + String.valueOf(scopeObj));
                    }
                }
                if (val instanceof ReferenceBinding) {
                    val = ParamCall.this.resolveReferenceBinding(name, (ReferenceBinding)val, returnType);
                }
                return val == null ? null : Classes.coerce(returnType, val);
            }
        });
        this._paramResolvers.put(SelectorParam.class, new ParamResolver<Annotation>(){

            @Override
            public Object resolveParameter(Annotation anno, Class<?> returnType, Supplier<String> parameterName) {
                String selector = ParamCall.this.getAnnotatedParameterName(SelectorParam.class, ((SelectorParam)anno).value(), parameterName);
                List result = Selectors.find((Component)ParamCall.this._root, (String)selector);
                Object val = !Collection.class.isAssignableFrom(returnType) ? (result.size() > 0 ? Classes.coerce(returnType, result.get(0)) : null) : Classes.coerce(returnType, (Object)result);
                return val;
            }
        });
    }

    private Object resolveReferenceBinding(String name, ReferenceBinding rbinding, Class<?> returnType) {
        BindEvaluatorX evalx = rbinding.getBinder().getEvaluatorX();
        Object val = BindEvaluatorXUtil.eval(evalx, rbinding.getComponent(), name, returnType, null);
        return val;
    }

    public void setExecution(Execution exec) {
        this._execution = exec;
        this._paramResolvers.put(QueryParam.class, new ParamResolver<Annotation>(){

            @Override
            public Object resolveParameter(Annotation anno, Class<?> returnType, Supplier<String> parameterName) {
                String val = ParamCall.this._execution.getParameter(ParamCall.this.getAnnotatedParameterName(QueryParam.class, ((QueryParam)anno).value(), parameterName));
                return val == null ? null : Classes.coerce(returnType, (Object)val);
            }
        });
        this._paramResolvers.put(HeaderParam.class, new ParamResolver<Annotation>(){

            @Override
            public Object resolveParameter(Annotation anno, Class<?> returnType, Supplier<String> parameterName) {
                String val = ParamCall.this._execution.getHeader(ParamCall.this.getAnnotatedParameterName(HeaderParam.class, ((HeaderParam)anno).value(), parameterName));
                return val == null ? null : Classes.coerce(returnType, (Object)val);
            }
        });
        this._paramResolvers.put(CookieParam.class, new ParamResolver<Annotation>(){

            @Override
            public Object resolveParameter(Annotation anno, Class<?> returnType, Supplier<String> parameterName) {
                Object val;
                HashMap<String, String> m = (HashMap<String, String>)ParamCall.this._execution.getAttribute(ParamCall.COOKIE_CACHE);
                if (m == null) {
                    Cookie[] cks;
                    Object req = ParamCall.this._execution.getNativeRequest();
                    m = new HashMap<String, String>();
                    ParamCall.this._execution.setAttribute(ParamCall.COOKIE_CACHE, m);
                    if (req instanceof HttpServletRequest && (cks = ((HttpServletRequest)req).getCookies()) != null) {
                        for (Cookie ck : cks) {
                            m.put(ck.getName().toLowerCase(Locale.ENGLISH), ck.getValue());
                        }
                    }
                }
                return (val = m.get(ParamCall.this.getAnnotatedParameterName(CookieParam.class, ((CookieParam)anno).value(), parameterName).toLowerCase(Locale.ENGLISH))) == null ? null : Classes.coerce(returnType, val);
            }
        });
        this._paramResolvers.put(ExecutionParam.class, new ParamResolver<Annotation>(){

            @Override
            public Object resolveParameter(Annotation anno, Class<?> returnType, Supplier<String> parameterName) {
                Object val = ParamCall.this._execution.getAttribute(ParamCall.this.getAnnotatedParameterName(ExecutionParam.class, ((ExecutionParam)anno).value(), parameterName));
                return val == null ? null : Classes.coerce(returnType, (Object)val);
            }
        });
        this._paramResolvers.put(ExecutionArgParam.class, new ParamResolver<Annotation>(){

            @Override
            public Object resolveParameter(Annotation anno, Class<?> returnType, Supplier<String> parameterName) {
                Object val = ParamCall.this._execution.getArg().get(ParamCall.this.getAnnotatedParameterName(ExecutionArgParam.class, ((ExecutionArgParam)anno).value(), parameterName));
                return val == null ? null : Classes.coerce(returnType, val);
            }
        });
    }

    class ContextObjects {
        ContextObjects() {
        }

        public Object get(ContextType type) {
            switch (type) {
                case BIND_CONTEXT: {
                    return ParamCall.this._bindContext;
                }
                case BINDER: {
                    return ParamCall.this._binder;
                }
                case COMMAND_NAME: {
                    return ParamCall.this._bindContext == null ? null : ParamCall.this._bindContext.getCommandName();
                }
                case TRIGGER_EVENT: {
                    return ParamCall.this._bindContext == null ? null : ParamCall.this._bindContext.getTriggerEvent();
                }
                case EXECUTION: {
                    return ParamCall.this._execution;
                }
                case COMPONENT: {
                    return ParamCall.this._component;
                }
                case SPACE_OWNER: {
                    return ParamCall.this._component == null ? null : ParamCall.this._component.getSpaceOwner();
                }
                case VIEW: {
                    return ParamCall.this._binder == null ? null : ParamCall.this._binder.getView();
                }
                case PAGE: {
                    return ParamCall.this._component == null ? null : ParamCall.this._component.getPage();
                }
                case DESKTOP: {
                    return ParamCall.this._component == null ? null : ParamCall.this._component.getDesktop();
                }
                case SESSION: {
                    return ParamCall.this._component == null ? null : Components.getImplicit((Component)ParamCall.this._component, (String)"session");
                }
                case APPLICATION: {
                    return ParamCall.this._component == null ? null : Components.getImplicit((Component)ParamCall.this._component, (String)"application");
                }
            }
            return null;
        }
    }

    public static interface ParamResolver<T> {
        default public Object resolveParameter(T anno, Class<?> returnType, Supplier<String> parameterName) {
            return null;
        }
    }

    private static class Type {
        final Class<?> clz;
        final Object value;

        public Type(Class<?> clz, Object value) {
            this.clz = clz;
            this.value = value;
        }
    }
}

