/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import org.zkoss.bind.BindContext;
import org.zkoss.bind.impl.MiscUtil;
import org.zkoss.bind.impl.PropertyExpression;
import org.zkoss.bind.impl.ReferenceBindingImpl;
import org.zkoss.bind.impl.SimpleBindXelContext;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.Binding;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.ValueReference;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.zel.ImportHandler;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.xel.impl.SimpleEvaluator;

public class BindEvaluatorXImpl
extends SimpleEvaluator
implements BindEvaluatorX {
    private static final long serialVersionUID = 1L;

    public BindEvaluatorXImpl(FunctionMapper mapper, Class<? extends ExpressionFactory> expfcls) {
        super(mapper, expfcls);
    }

    public Object getValue(BindContext ctx, Component comp, ExpressionX expression) throws XelException {
        try {
            if (expression instanceof PropertyExpression) {
                return expression.evaluate(null);
            }
            return expression.evaluate(this.newXelContext(ctx, comp));
        }
        catch (Exception x) {
            throw MiscUtil.mergeExceptionInfo(x, comp);
        }
    }

    public void setValue(BindContext ctx, Component comp, ExpressionX expression, Object value) throws XelException {
        try {
            if (expression instanceof PropertyExpression) {
                expression.setValue(null, value);
            } else {
                expression.setValue(this.newXelContext(ctx, comp), value);
            }
        }
        catch (Exception x) {
            throw MiscUtil.mergeExceptionInfo(x, comp);
        }
    }

    public ExpressionX parseExpressionX(BindContext ctx, String expression, Class<?> expectedType) throws XelException {
        Binding binding;
        Component comp = null;
        if (ctx != null && (comp = ctx.getComponent()) == null && (binding = ctx.getBinding()) != null) {
            comp = binding.getComponent();
        }
        try {
            return (ExpressionX)this.getExpressionFactory().parseExpression(this.newXelContext(ctx, comp), "${" + expression + "}", expectedType);
        }
        catch (Exception x) {
            throw MiscUtil.mergeExceptionInfo(x, comp);
        }
    }

    public Class<?> getType(BindContext ctx, Component comp, ExpressionX expression) throws XelException {
        return expression.getType(this.newXelContext(ctx, comp));
    }

    public ValueReference getValueReference(BindContext ctx, Component comp, ExpressionX expression) throws XelException {
        try {
            ValueReference ref = expression.getValueReference(this.newXelContext(ctx, comp));
            if (ref == null) {
                Object val;
                XelContext xctx = this.newXelContext(ctx, comp);
                if (ctx.getAttribute((Object)"$IGNORE_REF_VALUE$") == null) {
                    xctx.setAttribute("$IGNORE_REF_VALUE$", (Object)Boolean.TRUE);
                }
                if ((val = expression.evaluate(xctx)) instanceof ReferenceBindingImpl) {
                    ref = ((ReferenceBindingImpl)val).getValueReference();
                }
            }
            return ref;
        }
        catch (Exception x) {
            throw MiscUtil.mergeExceptionInfo(x, comp);
        }
    }

    protected XelContext newXelContext(BindContext ctx, final Component comp) {
        Page page;
        FunctionMapper mapper = this.getFunctionMapper(comp);
        VariableResolver resolver = new VariableResolver(){

            public Object resolveVariable(String name) throws XelException {
                VariableResolver vr = BindEvaluatorXImpl.this.getVariableResolver(comp);
                return vr == null ? null : vr.resolveVariable(name);
            }
        };
        SimpleBindXelContext xelc = new SimpleBindXelContext(comp, ctx != null ? ctx.getBinder() : null, resolver, mapper);
        xelc.setAttribute("$BINDCTX$", ctx);
        if (ctx != null) {
            xelc.setAttribute("$BINDING$", ctx.getBinding());
            xelc.setAttribute("$IGNORE_TRACKER$", ctx.getAttribute((Object)"$IGNORE_TRACKER$"));
        }
        if (comp != null && (page = Components.getCurrentPage((Component)comp)) != null) {
            xelc.setAttribute(ImportHandler.PageClassResolver.class.getName(), arg_0 -> ((Page)page).resolveClass(arg_0));
        }
        return xelc;
    }

    public boolean isReadOnly(BindContext ctx, Component comp, ExpressionX expression) throws XelException {
        return expression.isReadOnly(this.newXelContext(ctx, comp));
    }
}

