/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.xel.zel;

import java.beans.FeatureDescriptor;
import java.util.Arrays;
import java.util.Iterator;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELException;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zel.PropertyNotWritableException;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelArray;
import org.zkoss.zul.ListModelList;

public class ListModelELResolver
extends ELResolver {
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ListModel) {
            ListModel listmodel = (ListModel)base;
            Integer idx = ListModelELResolver.coerce(property);
            if (idx == null) {
                return null;
            }
            context.setPropertyResolved(true);
            if (idx >= 0 && idx < listmodel.getSize()) {
                return listmodel.getElementAt(idx.intValue());
            }
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ListModel) {
            ListModel listmodel = (ListModel)base;
            Integer idx = ListModelELResolver.coerce(property);
            if (idx == null) {
                return null;
            }
            if (idx < 0 || idx >= listmodel.getSize()) {
                throw new PropertyNotFoundException(new ArrayIndexOutOfBoundsException(idx).getMessage());
            }
            context.setPropertyResolved(true);
            return Object.class;
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ListModel) {
            ListModel listmodel = (ListModel)base;
            Integer idx = ListModelELResolver.coerce(property);
            if (idx == null) {
                return;
            }
            context.setPropertyResolved(true);
            if (idx >= 0 && idx < listmodel.getSize()) {
                if (base instanceof ListModelArray) {
                    ((ListModelArray)base).set(idx.intValue(), value);
                } else if (base instanceof ListModelList) {
                    ((ListModelList)base).set(idx.intValue(), value);
                } else {
                    throw new PropertyNotWritableException("can't write property " + String.valueOf(property) + " to ListModel:" + String.valueOf(base));
                }
            }
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        return true;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base instanceof ListModel) {
            FeatureDescriptor[] descs = new FeatureDescriptor[((ListModel)base).getSize()];
            for (int i = 0; i < descs.length; ++i) {
                descs[i] = new FeatureDescriptor();
                descs[i].setDisplayName("[" + i + "]");
                descs[i].setExpert(false);
                descs[i].setHidden(false);
                descs[i].setName("" + i);
                descs[i].setPreferred(true);
                descs[i].setValue("resolvableAtDesignTime", Boolean.FALSE);
                descs[i].setValue("type", Integer.class);
            }
            return Arrays.asList(descs).iterator();
        }
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof ListModel) {
            return Integer.class;
        }
        return null;
    }

    private static final Integer coerce(Object property) {
        if (property instanceof Number) {
            return ((Number)property).intValue();
        }
        if (property instanceof Character) {
            return ((Character)property).charValue();
        }
        if (property instanceof Boolean) {
            return (Boolean)property != false ? 1 : 0;
        }
        if (property instanceof String) {
            try {
                return Integer.parseInt((String)property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

