/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Property;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.BindEvaluatorXUtil;
import org.zkoss.bind.impl.BindingImpl;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ReferenceBinding;
import org.zkoss.bind.sys.debugger.BindingExecutionInfoCollector;
import org.zkoss.bind.sys.debugger.impl.info.LoadInfo;
import org.zkoss.bind.sys.debugger.impl.info.SaveInfo;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.ValueReference;
import org.zkoss.zk.ui.Component;

public class ReferenceBindingImpl
extends BindingImpl
implements ReferenceBinding {
    private static final long serialVersionUID = 20120204122151L;
    private static final Object NULL_VALUE = new Object();
    private ExpressionX _exprX;
    private final String _expression;
    private transient Object _cacheValue;
    private final String _attr;

    public ReferenceBindingImpl(Binder binder, Component comp, String attr, String expression) {
        super(binder, comp, null);
        this._expression = expression;
        this._attr = attr;
    }

    private ExpressionX initExpressionX() {
        if (this._exprX == null) {
            BindContext ctx = this.newBindContext();
            this._exprX = this.getBinder().getEvaluatorX().parseExpressionX(ctx, this._expression, Object.class);
        }
        return this._exprX;
    }

    @Override
    public Object getValue(BindELContext ctx) {
        this.load(null);
        return this._cacheValue == NULL_VALUE ? null : this._cacheValue;
    }

    @Override
    public void setValue(BindELContext ctx, Object val) {
        Set<Property> notifies;
        this.invalidateCache();
        BindContext bctx = this.newBindContext();
        this.getBinder().getEvaluatorX().setValue(bctx, this.getComponent(), this.initExpressionX(), val);
        BindingExecutionInfoCollector collector = ((BinderCtrl)this.getBinder()).getBindingExecutionInfoCollector();
        if (collector != null) {
            collector.addInfo(new SaveInfo("reference", this.getComponent(), null, this._attr, this.getPropertyString(), val, null, null));
        }
        if ((notifies = BindELContext.getNotifys(bctx)) != null) {
            BindELContext.addNotifys(notifies, ctx.getBindContext());
        }
    }

    private BindContext newBindContext() {
        return BindContextUtil.newBindContext(this.getBinder(), this, false, null, this.getComponent(), null);
    }

    @Override
    public void load(BindContext ctx) {
        if (this._cacheValue == null) {
            BindContext bctx = this.newBindContext();
            Object val = this.getBinder().getEvaluatorX().getValue(bctx, this.getComponent(), this.initExpressionX());
            this._cacheValue = val == null ? NULL_VALUE : val;
            BindingExecutionInfoCollector collector = ((BinderCtrl)this.getBinder()).getBindingExecutionInfoCollector();
            if (collector != null) {
                collector.addInfo(new LoadInfo("reference", this.getComponent(), null, this.getPropertyString(), this._attr, this._cacheValue, null, null));
            }
        }
    }

    @Override
    public String getPropertyString() {
        return BindEvaluatorXUtil.getExpressionString(this.initExpressionX());
    }

    @Override
    public void invalidateCache() {
        this._cacheValue = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ",component:" + this.getComponent();
    }

    ValueReference getValueReference() {
        BindContext bctx = this.newBindContext();
        return this.getBinder().getEvaluatorX().getValueReference(bctx, this.getComponent(), this.initExpressionX());
    }
}

