/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.validator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.zkoss.bind.Property;
import org.zkoss.bind.ValidationContext;
import org.zkoss.bind.validator.AbstractValidator;
import org.zkoss.bind.validator.BeanValidations;

public class BeanValidator
extends AbstractValidator {
    protected Validator getValidator() {
        return BeanValidations.getValidator();
    }

    protected Set<ConstraintViolation<?>> validate(Class clz, String property, Object value, Class<?>[] groups) {
        if (groups != null) {
            return this.getValidator().validateValue(clz, property, value, (Class[])groups);
        }
        return this.getValidator().validateValue(clz, property, value, new Class[0]);
    }

    public void validate(ValidationContext ctx) {
        Property p = ctx.getProperty();
        Object base = p.getBase();
        String property = p.getProperty();
        Object value = p.getValue();
        Object[] info = this.getValidationInfo(ctx, base, property);
        Class clz = (Class)info[0];
        property = (String)info[1];
        Class[] groups = (Class[])ctx.getValidatorArg("groups");
        Set<ConstraintViolation<?>> violations = this.validate(clz, property, value, groups);
        this.handleConstraintViolation(ctx, violations);
    }

    protected void sort(List<ConstraintViolation<?>> viloations) {
        Collections.sort(viloations, new Comparator<ConstraintViolation<?>>(){

            @Override
            public int compare(ConstraintViolation<?> o1, ConstraintViolation<?> o2) {
                String s1 = o1.getConstraintDescriptor().getAnnotation().toString();
                String s2 = o2.getConstraintDescriptor().getAnnotation().toString();
                return s1.compareTo(s2);
            }
        });
    }

    protected Object[] getValidationInfo(ValidationContext ctx, Object base, String property) {
        Class<?> clz = base.getClass();
        return new Object[]{clz, property};
    }

    protected void handleConstraintViolation(ValidationContext ctx, Set<ConstraintViolation<?>> violations) {
        String key = (String)ctx.getValidatorArg("key");
        int s = violations.size();
        if (s == 1) {
            this.addInvalidMessage(ctx, key, violations.iterator().next().getMessage());
        } else if (s > 0) {
            String[] msgs = new String[violations.size()];
            ArrayList l = new ArrayList(violations);
            this.sort(l);
            for (int i = 0; i < msgs.length; ++i) {
                msgs[i] = ((ConstraintViolation)l.get(i)).getMessage();
            }
            this.addInvalidMessages(ctx, key, msgs);
        }
    }
}

