/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.proxy;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.annotation.ImmutableElements;
import org.zkoss.bind.proxy.AbstractCollectionProxy;
import org.zkoss.bind.proxy.FormProxyObject;
import org.zkoss.bind.proxy.ProxyHelper;
import org.zkoss.bind.proxy.ProxyNode;
import org.zkoss.bind.proxy.ProxyNodeImpl;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.sys.SavePropertyBinding;
import org.zkoss.lang.Objects;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.ListModelMap;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PagingListener;
import org.zkoss.zul.ext.SelectionControl;

public class ListModelMapProxy<K, V>
extends ListModelMap<K, V>
implements Proxy,
FormProxyObject,
Serializable {
    private static final long serialVersionUID = 20210608113022L;
    private static final Logger log = LoggerFactory.getLogger(ListModelMapProxy.class);
    private MapForCache<K, V> _cache;
    private ListModelMap<K, V> _origin;
    private boolean _dirty;
    private boolean isImmutableElements;
    private ProxyNode _node;

    public ListModelMapProxy(ListModelMap<K, V> origin, Annotation[] callerAnnots) {
        this._origin = origin;
        this._cache = new MapForCache(origin.size());
        if (callerAnnots != null) {
            for (Annotation annot : callerAnnots) {
                if (!annot.annotationType().isAssignableFrom(ImmutableElements.class)) continue;
                this.isImmutableElements = true;
                break;
            }
        }
        this.resetFromOrigin();
    }

    private ListModelMap<K, V> initCache() {
        ListModelMap cache = new ListModelMap(this.getOriginObject().size());
        return cache;
    }

    private ListModelMap<K, V> getCache() {
        return this._cache;
    }

    public void addListDataListener(ListDataListener l) {
        this.getCache().addListDataListener(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.getCache().removeListDataListener(l);
    }

    public Set<Map.Entry<K, V>> getSelection() {
        return this.getCache().getSelection();
    }

    public void setSelection(Set<Map.Entry<K, V>> selection) {
        this.getCache().setSelection(selection);
        this.setDirty(true);
    }

    public boolean isSelected(Object obj) {
        return this.getCache().isSelected(obj);
    }

    public boolean isSelectionEmpty() {
        return this.getCache().isSelectionEmpty();
    }

    public boolean addToSelection(Map.Entry<K, V> obj) {
        boolean result = this.getCache().addToSelection(obj);
        if (result) {
            this.setDirty(true);
        }
        return result;
    }

    public boolean removeFromSelection(Object obj) {
        boolean result = this.getCache().removeFromSelection(obj);
        if (result) {
            this.setDirty(true);
        }
        return result;
    }

    public void clearSelection() {
        if (!this.getCache().getSelection().isEmpty()) {
            this.getCache().clearSelection();
            this.setDirty(true);
        }
    }

    public void setMultiple(boolean multiple) {
        if (this.getCache().isMultiple() != multiple) {
            this.getCache().setMultiple(multiple);
            this.setDirty(true);
        }
    }

    public void setSelectionControl(SelectionControl ctrl) {
        this.getCache().setSelectionControl(ctrl);
    }

    public SelectionControl getSelectionControl() {
        return this.getCache().getSelectionControl();
    }

    public void addSelection(Map.Entry<K, V> obj) {
        this.addToSelection(obj);
    }

    public void removeSelection(Object obj) {
        this.removeFromSelection(obj);
    }

    public int getPageSize() {
        return this.getCache().getPageSize();
    }

    public void setPageSize(int size) throws WrongValueException {
        this.getCache().setPageSize(size);
        this.setDirty(true);
    }

    public int getPageCount() {
        return this.getCache().getPageCount();
    }

    public int getActivePage() {
        return this.getCache().getActivePage();
    }

    public void setActivePage(int pg) throws WrongValueException {
        this.getCache().setActivePage(pg);
        this.setDirty(true);
    }

    public void addPagingEventListener(PagingListener l) {
        this.getCache().addPagingEventListener(l);
    }

    public void removePagingEventListener(PagingListener l) {
        this.getCache().removePagingEventListener(l);
    }

    public Map<K, V> getInnerMap() {
        return this.getCache().getInnerMap();
    }

    public int getSize() {
        return this.getCache().getSize();
    }

    public Map.Entry<K, V> getElementAt(int j) {
        return this.getCache().getElementAt(j);
    }

    public boolean containsKey(Object key) {
        return this.getCache().containsKey(this.createProxyObject(key));
    }

    public boolean containsValue(Object value) {
        Iterator it = this.getCache().values().iterator();
        Object proxyValue = this.createProxyObject(value);
        while (it.hasNext()) {
            if (!AbstractCollectionProxy.testEquals(it.next(), proxyValue)) continue;
            return true;
        }
        return false;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.getCache().entrySet();
    }

    public boolean equals(Object o) {
        return this.getCache().equals(o);
    }

    public String toString() {
        return this.getCache().toString();
    }

    public int hashCode() {
        return this.getCache().hashCode();
    }

    public boolean isEmpty() {
        return this.getCache().isEmpty();
    }

    public V get(Object key) {
        return (V)this.getCache().get(this.createProxyObject(key));
    }

    public V put(K key, V value) {
        V o = this.createProxyObject(value);
        if (o instanceof FormProxyObject) {
            this.setCreatedProxyPath((FormProxyObject)o, key);
        }
        this.setDirty(true);
        return (V)this.getCache().put(this.createProxyObject(key), o);
    }

    public V remove(Object key) {
        this.setDirty(true);
        return (V)this.getCache().remove(this.createProxyObject(key));
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void clear() {
        this.setDirty(true);
        this.getCache().clear();
    }

    public Set<K> keySet() {
        return this.getCache().keySet();
    }

    public Collection<V> values() {
        return this.getCache().values();
    }

    public int indexOfKey(Object o) {
        return this.getCache().indexOfKey(this.createProxyObject(o));
    }

    public int indexOf(Object o) {
        return this.getCache().indexOf(this.createProxyObject(o));
    }

    public int size() {
        return this.getCache().size();
    }

    public void sort(Comparator<Map.Entry<K, V>> cmpr, boolean ascending) {
        this.getCache().sort(cmpr, ascending);
        this.setDirty(true);
    }

    public void sort() {
        this.getCache().sort();
        this.setDirty(true);
    }

    public String getSortDirection(Comparator<Map.Entry<K, V>> cmpr) {
        return this.getCache().getSortDirection(cmpr);
    }

    public Object clone() {
        return this.getCache().clone();
    }

    public ListModelMap<K, V> getOriginObject() {
        return this._origin;
    }

    public void onDirtyChange() {
        ProxyHelper.callOnDirtyChange(this._node);
    }

    public void onDataChange(Object o) {
        ProxyHelper.callOnDataChange(this._node, new Object[]{o, "."});
    }

    protected void setDirty(boolean d) {
        if (this._dirty != d) {
            this._dirty = d;
            this.onDirtyChange();
        }
        if (d) {
            this.onDataChange(this);
        }
    }

    public void setHandler(MethodHandler mi) {
        throw new UnsupportedOperationException("Not support!");
    }

    public boolean isFormDirty() {
        if (this._dirty) {
            return true;
        }
        for (Map.Entry me : this.getCache().entrySet()) {
            if (!(me.getValue() instanceof FormProxyObject) || !((FormProxyObject)me.getValue()).isFormDirty()) continue;
            return true;
        }
        return false;
    }

    public void resetFromOrigin() {
        this.getCache().clear();
        this.setDirty(false);
        for (Map.Entry me : this.getOriginObject().entrySet()) {
            Object o = this.createProxyObject(me.getValue());
            this.getCache().put(this.createProxyObject(me.getKey()), o);
            if (!(o instanceof FormProxyObject)) continue;
            this.setCreatedProxyPath((FormProxyObject)o, me.getKey());
        }
    }

    public void submitToOrigin(BindContext ctx) {
        this._origin.clear();
        for (Map.Entry me : this.getCache().entrySet()) {
            Object value = me.getValue();
            if (value instanceof FormProxyObject) {
                FormProxyObject proxyValue = (FormProxyObject)value;
                proxyValue.submitToOrigin(ctx);
                this._origin.put(me.getKey(), proxyValue.getOriginObject());
                continue;
            }
            this._origin.put(me.getKey(), me.getValue());
        }
        this.setDirty(false);
    }

    protected static boolean testEquals(Object e, Object o) {
        if (e == o) {
            return true;
        }
        if (e instanceof FormProxyObject) {
            Object eo = ((FormProxyObject)e).getOriginObject();
            Object oo = o;
            if (o instanceof FormProxyObject) {
                oo = ((FormProxyObject)o).getOriginObject();
            }
            if (Objects.equals((Object)eo, (Object)oo)) {
                return true;
            }
        } else if (o instanceof FormProxyObject ? Objects.equals((Object)e, (Object)((FormProxyObject)o).getOriginObject()) : Objects.equals((Object)e, (Object)o)) {
            return true;
        }
        return false;
    }

    public void setFormOwner(Object owner, FormBinding binding) {
        throw new IllegalAccessError("Not supported");
    }

    private <T> T createProxyObject(T t) {
        return this.isImmutableElements ? t : ProxyHelper.createProxyIfAny(t);
    }

    private void setCreatedProxyPath(FormProxyObject fpo, Object key) {
        fpo.setPath("['" + String.valueOf(key) + "']", this._node);
    }

    public void cacheSavePropertyBinding(String property, SavePropertyBinding s) {
        ProxyHelper.cacheSavePropertyBinding(this._node, this._node.getProperty() + "['" + property + "']", s);
    }

    public Set<Pair<String, SavePropertyBinding>> collectCachedSavePropertyBinding() {
        throw new UnsupportedOperationException("Not support!");
    }

    public void setPath(String property, ProxyNode parent) {
        if (property == null && this._node != null) {
            this._node.setParent(parent);
        } else {
            this._node = new ProxyNodeImpl(property, parent);
            for (Map.Entry e : this.getCache().entrySet()) {
                if (!(e.getValue() instanceof FormProxyObject)) continue;
                ((FormProxyObject)this.getCache().get(e.getKey())).setPath(null, this._node);
            }
        }
    }

    private class SetHandlerForCache
    implements MethodHandler {
        private Set _origin;

        public SetHandlerForCache(Set origin) {
            this._origin = origin;
        }

        public Object invoke(Object self, Method method, Method proceed, Object[] args) throws Throwable {
            String mname = method.getName();
            if (mname.equals("contains")) {
                return method.invoke((Object)this._origin, ListModelMapProxy.this.createProxyObject(args[0]));
            }
            if (mname.equals("remove")) {
                return method.invoke((Object)this._origin, ListModelMapProxy.this.createProxyObject(args[0]));
            }
            return method.invoke((Object)this._origin, args);
        }
    }

    private class MapForCache<K, V>
    extends ListModelMap<K, V> {
        private transient Set<Map.Entry<K, V>> _entrySetProxy;
        private transient Set<K> _keySetProxy;

        public MapForCache() {
            this._entrySetProxy = null;
            this._keySetProxy = null;
        }

        public MapForCache(int size) {
            super(size);
            this._entrySetProxy = null;
            this._keySetProxy = null;
        }

        public Set<Map.Entry<K, V>> entrySet() {
            return this._entrySetProxy == null ? this.createProxy(true) : this._entrySetProxy;
        }

        public Set<K> keySet() {
            return this._keySetProxy == null ? this.createProxy(false) : this._keySetProxy;
        }

        private Set createProxy(boolean isEntry) {
            Set proxy = null;
            ProxyFactory factory = new ProxyFactory();
            factory.setUseWriteReplace(false);
            factory.setSuperclass(AbstractSet.class);
            factory.createClass();
            try {
                if (isEntry) {
                    proxy = this._entrySetProxy = (Set)factory.createClass().newInstance();
                    ((Proxy)this._entrySetProxy).setHandler((MethodHandler)new SetHandlerForCache(super.entrySet()));
                } else {
                    proxy = this._keySetProxy = (Set)factory.createClass().newInstance();
                    ((Proxy)this._keySetProxy).setHandler((MethodHandler)new SetHandlerForCache(super.keySet()));
                }
            }
            catch (Exception e) {
                log.warn("", (Throwable)e);
            }
            return proxy;
        }
    }
}

