/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.AbstractForEachStatus;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.sys.TemplateResolver;
import org.zkoss.xel.ExpressionX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Template;

public class TemplateResolverImpl
implements TemplateResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String _templateExpr;
    private final Map<String, Object> _templateArgs;
    private final Binder _binder;
    private final String _attr;
    private final Component _comp;
    private final ExpressionX _expression;

    public TemplateResolverImpl(Binder binder, Component comp, String attr, String templateExpr, Map<String, Object> templateArgs) {
        this._binder = binder;
        this._comp = comp;
        this._templateExpr = templateExpr;
        this._templateArgs = templateArgs;
        this._attr = attr;
        BindContext ctx = BindContextUtil.newBindContext(binder, null, false, null, this._comp, null);
        this._expression = binder.getEvaluatorX().parseExpressionX(ctx, templateExpr, Object.class);
    }

    public Binder getBinder() {
        return this._binder;
    }

    public Component getComponent() {
        return this._comp;
    }

    public String getExpression() {
        return this._templateExpr;
    }

    public Map<String, Object> getTemplateArgs() {
        return this._templateArgs;
    }

    public String getAttr() {
        return this._attr;
    }

    private Template lookupTemplate(Component comp, String name) {
        if (comp == null) {
            return null;
        }
        Template template = comp.getTemplate(name);
        return template == null ? this.lookupTemplate(comp.getParent(), name) : template;
    }

    protected Object evaluateTemplate(Component eachComp, Object eachData, int index, int size) {
        return this.evaluateTemplate(eachComp, eachData, index, size, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evaluateTemplate(Component eachComp, final Object eachData, final int index, final int size, String subType) {
        Object object;
        Object oldStatus;
        block9: {
            block8: {
                Object oldEach = null;
                oldStatus = null;
                try {
                    Object value;
                    oldEach = eachComp.setAttribute("each", eachData);
                    oldStatus = eachComp.setAttribute("forEachStatus", (Object)new AbstractForEachStatus(){
                        private static final long serialVersionUID = 1L;

                        public int getIndex() {
                            return index;
                        }

                        public Object getCurrent() {
                            return eachData;
                        }

                        public Integer getEnd() {
                            if (size < 0) {
                                throw new UiException("end attribute is not supported");
                            }
                            return size;
                        }
                    });
                    BindEvaluatorX eval = this._binder.getEvaluatorX();
                    BindContext ctx = BindContextUtil.newBindContext(this._binder, null, false, null, eachComp, null);
                    object = value = eval.getValue(ctx, eachComp, this._expression);
                    if (oldEach == null) break block8;
                }
                catch (Throwable throwable) {
                    if (oldEach != null) {
                        eachComp.setAttribute("each", oldEach);
                    } else {
                        eachComp.removeAttribute("each");
                    }
                    if (oldStatus != null) {
                        eachComp.setAttribute("forEachStatus", oldStatus);
                    } else {
                        eachComp.removeAttribute("forEachStatus");
                    }
                    throw throwable;
                }
                eachComp.setAttribute("each", oldEach);
                break block9;
            }
            eachComp.removeAttribute("each");
        }
        if (oldStatus != null) {
            eachComp.setAttribute("forEachStatus", oldStatus);
        } else {
            eachComp.removeAttribute("forEachStatus");
        }
        return object;
    }

    public Template resolveTemplate(Component eachComp, Object eachData, int index, int size) {
        return this.resolveTemplate(eachComp, eachData, index, size, null);
    }

    @Override
    public Template resolveTemplate(Component eachComp, Object eachData, int index, int size, String subType) {
        Object value = this.evaluateTemplate(eachComp, eachData, index, size, subType);
        if (value instanceof Template) {
            return (Template)value;
        }
        if (value instanceof String) {
            Template template;
            if (subType == null) {
                template = this.lookupTemplate(eachComp, (String)value);
            } else {
                template = this.lookupTemplate(eachComp, (String)value + ":" + subType);
                if (template == null) {
                    template = this.lookupTemplate(eachComp, (String)value);
                }
            }
            if (template == null && ((String)value).indexOf(46) > 0) {
                try {
                    template = (Template)this._comp.getPage().resolveClass((String)value).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return template;
        }
        throw new UiException("unknow template type " + String.valueOf(value));
    }

    @Override
    public void addTemplateTracking(Component eachComp, Object eachData, int index, int size) {
        Binding binding = this.getTemplateBinding(eachComp, eachData, index, size);
        if (binding != null) {
            BindContext ctx = BindContextUtil.newBindContext(this._binder, binding, false, null, eachComp, null);
            BindEvaluatorX eval = this._binder.getEvaluatorX();
            ExpressionX exprX = eval.parseExpressionX(ctx, this._templateExpr, Object.class);
            eval.getValue(ctx, eachComp, exprX);
        }
    }

    protected Binding getTemplateBinding(Component eachComp, Object eachData, int index, int size) {
        List<Binding> bindings = ((BinderCtrl)this._binder).getLoadPromptBindings(this._comp, this._attr);
        Binding loadbinding = bindings.size() > 0 ? bindings.get(bindings.size() - 1) : null;
        return loadbinding;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this._templateExpr).append("]").append(super.toString());
        return sb.toString();
    }
}

