/* kkjsp.js

	Purpose:

	Description:

	History:
		Wed Feb 12 09:59:43 CST 2020, Created by jumperchen

Copyright (C) 2020 Potix Corporation. All Rights Reserved.
*/
/**
 * @class kkjsp
 * Keikai JSP utils
 * @since 5.1.0
 */
kkjsp = {
  /**
   * Prepares the ajax data from the given spreadsheet's uuid with a given request data
   * @param String uuid the spreadsheet's uuid
   * @param  Map data the request data.
   * @returns Map the merged data between spreadsheet component and request data.
   */
  prepare: function (uuid, data) {
    let d = zssjsp[uuid];
    return (Object.assign ? Object.assign : jq.entend)(data, {
      '$dtid': d.desktopId,
      '$uid': d.uuid
    });
  },
  /**
   * Processes the ajax response output from the Keikai's server side.
   * @param Map data the json format data which returned from Keikai's server side.
   * @returns Map data the json format data that user defined from Keikai's server side.
   */
  process: function (data) {
    zssjsp.processJson(data);
    return data;
  }
};