/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.jsf.ui;

import io.keikai.api.model.Book;
import io.keikai.jsf.ui.impl.JSFComponentBase;
import io.keikai.jsf.ui.impl.ObjectHolderContext;
import io.keikai.ui.Spreadsheet;
import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.StateHelper;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;

@FacesComponent(value="io.keikai.Spreadsheet")
public class JSFSpreadsheet
extends JSFComponentBase {
    private static final Logger log = LoggerFactory.getLogger(JSFSpreadsheet.class);

    public Spreadsheet getSpreadsheet() {
        return (Spreadsheet)this.getZKComponent();
    }

    @Override
    protected Component newZKComponent() {
        return new Spreadsheet();
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = this.getClientId(context);
        writer.startElement("div", (UIComponent)this);
        writer.writeAttribute("id", (Object)id, "id");
        StateHelper sh = this.getStateHelper();
        String sclass = (String)this.getStateProperty("sclass");
        String style = (String)this.getStateProperty("style");
        String width = (String)this.getStateProperty("width");
        String height = (String)this.getStateProperty("height");
        if (!Strings.isEmpty((String)sclass)) {
            writer.writeAttribute("class", (Object)("zssjsf " + sclass), null);
        } else {
            writer.writeAttribute("class", (Object)"zssjsf", null);
        }
        if (!Strings.isEmpty((String)width)) {
            style = JSFSpreadsheet.appendStyle(style, "width", width);
        }
        if (!Strings.isEmpty((String)height)) {
            style = JSFSpreadsheet.appendStyle(style, "height", height);
        }
        if (!Strings.isEmpty((String)style)) {
            writer.writeAttribute("style", (Object)style, null);
        }
        super.encodeBegin(context);
        String zssid = this.getZKComponent().getUuid();
        writer.append((CharSequence)"<script type=\"text/javascript\">zk.afterLoad(function(){");
        writer.append((CharSequence)("zssjsf.fixSize('" + zssid + "');"));
        writer.append((CharSequence)("zssjsf.fixTomcatTrunkIssue('" + zssid + "');"));
        writer.append((CharSequence)"});</script>");
        writer.endElement("div");
    }

    @Override
    protected void releaseResource(Component compToBeDrop) {
        ((Spreadsheet)compToBeDrop).setBook(null);
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        try {
            this.updateBook(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    protected void updateBook(FacesContext context) {
        Spreadsheet ss;
        ELContext ctx;
        if (context == null) {
            throw new NullPointerException();
        }
        ValueExpression ve = this.getValueExpression("book");
        if (ve != null && !ve.isReadOnly(ctx = context.getELContext())) {
            ss = this.getSpreadsheet();
            Book book = ss == null ? (Book)ObjectHolderContext.getObjectIfAny(this.getZKDesktopId(), this.getZKComponentUuid() + ".book") : ss.getBook();
            ve.setValue(context.getELContext(), (Object)book);
        }
        if ((ve = this.getValueExpression("selectedSheetName")) != null && !ve.isReadOnly(ctx = context.getELContext())) {
            ss = this.getSpreadsheet();
            String nm = ss == null ? (String)ObjectHolderContext.getObjectIfAny(this.getZKDesktopId(), this.getZKComponentUuid() + ".selectedSheetName") : ss.getSelectedSheetName();
            ve.setValue(context.getELContext(), (Object)nm);
        }
    }

    @Override
    protected JSFComponentBase.DeadComponentHolderListener newDeadComponentHolderListener() {
        return new DeadSSHolderListener();
    }

    protected static class DeadSSHolderListener
    extends JSFComponentBase.DeadComponentHolderListener {
        private static final long serialVersionUID = 1L;

        protected DeadSSHolderListener() {
        }

        @Override
        protected void holdData(Desktop desktop, Component comp) {
            if (comp == null) {
                return;
            }
            Spreadsheet ss = (Spreadsheet)comp;
            ObjectHolderContext.putObject(desktop.getId(), this.getComponentUuid() + ".book", ss.getBook());
            ObjectHolderContext.putObject(desktop.getId(), this.getComponentUuid() + ".selectedSheetName", ss.getSelectedSheetName());
        }
    }
}

