/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.jsf.ui.impl;

import io.keikai.jsf.ui.impl.ObjectHolderContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class ObjectHolder
extends ObjectHolderContext
implements Serializable {
    private static final long serialVersionUID = 4832818033988336706L;
    private static final String key = "$keikai.jsf.objectHolder$";
    private HttpSession session;
    private int millisecondToKick;

    public ObjectHolder(HttpSession session, int millisecondToKick) {
        this.session = session;
        this.millisecondToKick = millisecondToKick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kick() {
        Map objects = (Map)this.session.getAttribute(key);
        if (objects != null) {
            long now = System.currentTimeMillis();
            Map map = objects;
            synchronized (map) {
                Iterator iter = objects.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (((ObjectWrapper)entry.getValue()).getTimeToKick() > now) continue;
                    iter.remove();
                }
                if (objects.size() == 0) {
                    this.session.removeAttribute(key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String objectId) {
        Map objects = (Map)this.session.getAttribute(key);
        Object object = null;
        if (objects != null) {
            Map map = objects;
            synchronized (map) {
                ObjectWrapper dd = (ObjectWrapper)objects.get(objectId);
                object = dd == null ? null : dd.getObject();
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String objectId, Object object) {
        Map<String, ObjectWrapper> objects;
        Map<String, ObjectWrapper> map = objects = this.getOrCreateObjectMap(this.session);
        synchronized (map) {
            objects.put(objectId, new ObjectWrapper(object, System.currentTimeMillis() + (long)this.millisecondToKick));
        }
    }

    private synchronized Map<String, ObjectWrapper> getOrCreateObjectMap(HttpSession session) {
        HashMap<String, ObjectWrapper> objects = (HashMap<String, ObjectWrapper>)session.getAttribute(key);
        if (objects == null) {
            objects = new HashMap<String, ObjectWrapper>();
        }
        session.setAttribute(key, objects);
        return objects;
    }

    static class ObjectWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        long timeToKick;
        transient Object object;

        public ObjectWrapper(Object object, long timeToKick) {
            this.object = object;
            this.timeToKick = timeToKick;
        }

        public long getTimeToKick() {
            return this.timeToKick;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

